//
//  BPDownloadManager.h
//  BISubstrate
//
//  Created by Alykhan Jetha on 10-05-08.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BISubstrateDefines.h"

@class BIDatabaseObjectContext;
@class BPURLDownloader;
@class BIURLReference;

@interface BPDownloadManager : NSObject {
	NSMutableArray *downloads;
	
	NSString *username;
	NSString *password;
	NSString *encodedUsername; // required because NSURLCredential has a bug and can only deal with ISOLatin1
	NSString *encodedPassword;
	NSString *cloudAccount;
    NSString *offlineID;
	
	BIDatabaseObjectContext *objectContext;
	
	BOOL hosted;
}

@property (retain) NSMutableArray *downloads;

@property (copy) NSString *username;
@property (copy) NSString *password;
@property (copy) NSString *encodedUsername;
@property (copy) NSString *encodedPassword;
@property (copy) NSString *cloudAccount;
@property (retain) NSString *offlineID;

@property (assign) BIDatabaseObjectContext *objectContext;

/*!
 Designated initializer. Extracts the username and password from the underlying system
 */
- (id)initWithObjectContext:(BIDatabaseObjectContext *)theOC;

/*!
 Asks the underlying system which host it last successfully connected to
 */
- (NSString *)hostname;

/*!
 Currently returns 7118
 */
- (NSString *)port;


- (BPDownloadStatus)statusForURLReference:(BIURLReference *)ref  downloader:(BPURLDownloader **)downloader;


- (NSString *)urlRequestStringForCurrentObjectNumberForKind:(NSString *)aKind;
- (NSString *)urlRequestStringToIncrementCurrentObjectNumberOfKind:(NSString *)aKind;
- (NSString *)urlRequestStringForUploadFileStorage;

- (NSString *)urlRequestStringForRelativeURL:(NSString *)aURLStr;

/*!
 When things like credentials change. Call this.
 */
- (void)updateCachedValues;

@end
